/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskHAIntegrity;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HAComponent
extends Component {
    HAComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    protected boolean checkSetup() {
        ErrorDescription errDesc = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!super.checkSetup()) {
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT: super.checkSetup() failed.");
            }
            return false;
        }
        if (this.getValidNodeList() == null) {
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT: getValidNodeList() failed.");
            }
            return false;
        }
        if (VerificationUtil.isCRSConfigured()) {
            MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
            errDesc = new ErrorDescription("5745", theMB);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT: isHAConfigured() failed.");
            }
            return false;
        }
        if (!VerificationUtil.isHAConfigured()) {
            errDesc = new ErrorDescription("4112", s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT: isHAConfigured() failed.");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        if (!retval) {
            return false;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 15: {
                TaskHAIntegrity taskHAI = new TaskHAIntegrity(validNodeArr);
                retval &= taskHAI.perform();
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"\n>>>> HAComponent:: Upload taskHAIntegrity >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskHAI.getResultSet());
                return retval;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    @Override
    public String getComponentName() {
        return "HA";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9958", false);
    }
}

